# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import functools


class WasNotSetupError(Exception):
    pass


class LazySetuper(object):
    def __init__(self):
        self._was_setup = False

    def _setup(self, *args, **kwargs):
        raise NotImplementedError

    @property
    def was_setup(self):
        return self._was_setup

    def setup(self, *args, **kwargs):
        if self.was_setup:
            return
        self._setup(*args, **kwargs)
        self._was_setup = True

    @staticmethod
    def setup_required(f):
        @functools.wraps(f)
        def wrapped(self, *args, **kwargs):
            if not self.was_setup:
                raise WasNotSetupError("call setup before {}".format(repr(f)))
            return f(self, *args, **kwargs)
        return wrapped
