# -*- coding: utf-8 -*-
import requests


class Recognizer(object):
    meta = {
        'firstname': {
            'meta': {
                'strategy': '{"StrategyName":"FirstnameOCR"}',
                'category': u'rus-firstnames-lexicon.window',
            },
        },
        'patronym': {
            'meta': {
                'strategy': '{"StrategyName":"PatronymOCR"}',
                'category': u'rus-patronyms-lexicon.window',
            },
        },
        'surname': {
            'meta': {
                'strategy': '{"StrategyName":"SurnameOCR"}',
                'category': u'rus-surnames-lexicon.window',
            },
        },
        'birthdate': {
            'meta': {
                'strategy': '{"StrategyName":"BirthDatesOCR"}',
                'category': u'dates-lexicon.window',
            },
        },
        'issuedate': {
            'meta': {
                'strategy': '{"StrategyName":"IssueDatesOCR"}',
                'category': u'dates-lexicon.window',
            },
        },
        'passportnumber': {
            'meta': {
                'strategy': '{"StrategyName":"PassportNumbersOCR"}',
                'category': u'passport_numbers-lexicon.window',
            },
            'extra': {
                'rotate': '90',
            },
        },
    }

    def __init__(self, url, key):
        self.url = url
        self.key = key
        requests.packages.urllib3.disable_warnings()

    def recognize(self, file):
        return {
            k: self._recognize(file, v['meta'], **v.get('extra', {}))
            for k, v in self.meta.iteritems()
        }

    def _recognize(self, file, meta, **extra):
        file.seek(0)
        data = self._request(files=dict({
            'file': file,
            'meta': meta['strategy'],
        }, **extra))
        if data:
            return self._get_best(data, meta['category'])
        return None

    def _request(self, **kwargs):
        headers = kwargs.pop('headers', {})
        headers.update({'Expect': ''})
        kwargs['headers'] = headers
        files = kwargs.pop('files', {})
        files.update({'apikey': self.key, 'langName': 'ru'})
        kwargs['files'] = files
        response = requests.post(self.url, **kwargs)
        response.raise_for_status()
        json = response.json()
        if json.get('status') == 'success':
            return json.get('data')
        return None

    @staticmethod
    def _get_best(data, category):
        def flatten_candidates():
            for block in data.get('blocks', []):
                for box in block.get('boxes', []):
                    for language in box.get('languages', []):
                        for text in language.get('texts', []):
                            yield {
                                'text': text['text'],
                                'rank': text['rank'],
                                'meta': text['words'][0]['meta']
                            }
        candidates = list(flatten_candidates())
        match_meta = filter(lambda x: x['meta'] == category, candidates)
        if match_meta:
            candidates = match_meta
        return max(candidates, key=lambda x: x['rank'])['text']
