# -*- coding: utf-8 -*-
from util.abort import abort

from flask import current_app as app
from flask_restful import reqparse, Resource as BaseResource
from gevent import Timeout


class Resource(BaseResource):
    def __init__(self, params=None):
        params = params or {}
        self.parser = self.create_parser(params)

    def dispatch_request(self, *args, **kwargs):
        with Timeout(kwargs.pop('timeout', app.config['RESOURCE_TIMEOUT'])):
            kwargs.update(self.parser.parse_args())
            try:
                return super(Resource, self).dispatch_request(*args, **kwargs)
            except Timeout:
                abort(503)
            except NotImplementedError:
                abort(405)

    @staticmethod
    def create_parser(params):
        parser = reqparse.RequestParser()
        for name, param in params.iteritems():
            parser.add_argument(name, **param)
        return parser
