# -*- coding: utf-8 -*-
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from smtplib import SMTP_SSL


class SmtpClient(object):
    def __init__(self, host, login, password, sender):
        self._smtp = SMTP_SSL(host)
        self._smtp.login(login, password)
        self._sender = sender

    def __enter__(self):
        return self

    def __exit__(self, *args):
        self._smtp.close()

    def send(self, recipient, subject, message, files):
        if isinstance(recipient, basestring):
            recipient = [recipient]
        base_message = MIMEMultipart()

        base_message['From'] = self._sender
        base_message['To'] = ', '.join(recipient)
        base_message['Subject'] = subject
        base_message.attach(MIMEText(message, _charset='utf8'))

        for name, data in files.items():
            part = MIMEApplication(data)
            part.add_header('Content-Disposition', 'attachment; filename="{}"'.format(name))
            base_message.attach(part)
        return self._smtp.sendmail(self._sender, recipient, base_message.as_string())
