from threading import Condition


class WaitGroup(object):
    """WaitGroup is like Go sync.WaitGroup.
    """
    def __init__(self, count):
        self.count = count
        self.cv = Condition()

    def done(self):
        with self.cv:
            self.count -= 1
            if self.count == 0:
                self.cv.notify_all()

    def wait(self):
        with self.cv:
            while self.count > 0:
                self.cv.wait()
