# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from flask_restful import fields

from yabus.common.fields import Required
from yabus import common


class Book(common.Book):
    fields = {
        'birthDate': Required(fields.String(attribute='birthDate'), types=basestring),
        'citizenshipCode': Required(fields.String(attribute='citizenshipCode'), types=basestring),
        'docNumber': Required(fields.FormattedString('{docSeries}{docNumber}'), types=basestring),
        'docTypeCode': Required(fields.String(attribute='docTypeCode'), types=basestring),
        'firstName': Required(fields.String(attribute='firstName'), types=basestring),
        'genderTypeCode': Required(fields.String(attribute='genderCode'), types=basestring),
        'lastName': Required(fields.String(attribute='lastName'), types=basestring),
        'middleName': Required(fields.String(attribute='middleName'), types=basestring),
        'ticketTypeCode': Required(fields.String(attribute='ticketTypeCode'), types=basestring),
        'email': Required(fields.String(attribute='email'), types=basestring),
        'phone': Required(fields.String(attribute='phone'), types=basestring),
        'dischargeStopId': Required(fields.String(attribute='dischargeStopId'), types=basestring),
        'pickupStopId': Required(fields.String(attribute='pickupStopId'), types=basestring),
    }
