# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from flask_restful import fields

from yabus import common
from yabus.common import fields as cfields


logger = logging.getLogger(__name__)


class Endpoint(common.Endpoint):

    fields = {
        "supplier_id": fields.String(attribute=lambda obj: obj['code'] if obj['type'] == 'city' else obj['id']),
        "type": common.Endpoint.Type(),
        "title": fields.String(attribute='name'),
        "description": cfields.ConcatString('name', 'region_name', 'country'),
        "latitude": fields.Float(),
        "longitude": fields.Float(),
        "country": fields.String(),
        "country_code": fields.String(attribute='country'),
        "region": fields.String(attribute='region_name'),
        "city_id": fields.String(attribute='cityId'),
    }
