# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from dateutil.parser import parse

from flask_restful import fields

from yabus.atlasbus.entities.ticket import Ticket
from yabus.atlasbus.identifiers import OrderID
from yabus.common import fields as cfields
from yabus import common
from yabus.common.entities import ticket


class Order(common.Order):

    @cfields.id_wrapper(OrderID)
    class OrderID(cfields.Dict):
        pass

    @cfields.converter
    class Status(common.Ticket.Status):
        conv = {
            'active': ticket.STATUS_SOLD,
            'confirmed': ticket.STATUS_SOLD,
            'cancelled': ticket.STATUS_RETURNED,
            'expired': ticket.STATUS_CANCELLED,
            'unknown': ticket.STATUS_UNKNOWN,
            'waiting_confirmation': ticket.STATUS_BOOKED,
            'error': ticket.STATUS_ERROR,
            'booked': ticket.STATUS_BOOKED,
            'landing': ticket.STATUS_SOLD,
        }

    class ExpirationDateTime(fields.DateTime):
        def format(self, value):
            value = parse(value)
            return super(Order.ExpirationDateTime, self).format(value)

    fields = {
        '@id': OrderID(order_sid='id'),
        'status': Status(attribute='status'),
        'partner': cfields.Constant('atlasbus'),
        'partnerName': cfields.Constant('Atlasbus'),
        'supplierId': fields.String(attribute='id'),
        'price': cfields.Price(attribute='onlinePrice'),
        'tickets': fields.List(Ticket),
        'expirationDateTime': ExpirationDateTime(attribute='expirationDateTime', dt_format=b'iso8601'),
    }

    @classmethod
    def format(cls, value):
        for t in value.get('tickets', []):
            t['order_sid'] = value['id']
        return super(Order, cls).format(value)
