# coding: utf-8
from flask_restful import fields

from yabus import common


class RefundInfo(common.RefundInfo):
    fields = {
        'price': fields.Float(attribute='amount.price'),
        'available': fields.Boolean(attribute='available', default=False),
    }

    @classmethod
    def format(cls, value):
        value['amount'] = value['amount'][0]
        return super(RefundInfo, cls).format(value)


class Refund(common.Refund):
    fields = {
        'price': fields.Float(attribute='amount.price'),
    }

    @classmethod
    def format(cls, value):
        value['amount'] = value['amount'][0]
        return super(Refund, cls).format(value)
