# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from flask_restful import fields

from yabus import common
from yabus.common import fields as cfields


class RideDetails(common.RideDetails):

    @cfields.converter
    class DocumentType(common.RideDetails.DocumentType):
        # id_ru: Паспорт РФ
        # passport_ru: Заграничный паспорт РФ
        # passport_by: Паспорт РБ
        # id_ua: Паспорт Украины
        # foreign_passport: Паспорт другого государства
        # birth_certificate_ru: Свидетельство о рождении РФ
        # soldier_id_ru: Удостоверение личности военнослужащего РФ
        # military_book_ru: Военный билет РФ
        # permit_of_residence_ru: Вид на жительство РФ
        # passport_su: Паспорт СССР
        conv = {
            'foreign_passport': common.RideDetails.DOC_TYPE_FOREIGN_PASSPORT,
            'birth_certificate_ru': common.RideDetails.DOC_TYPE_BIRTH_CERT,
            'id_ru': common.RideDetails.DOC_TYPE_PASSPORT,
            'passport_by': common.RideDetails.DOC_TYPE_BELORUSSIAN_PASSPORT,
            'passport_ru': common.RideDetails.DOC_TYPE_INTERNATIONAL_PASSPORT,
        }

    @cfields.converter
    class TicketType(common.RideDetails.TicketType):
        conv = {
            'baggage': common.RideDetails.TICKET_TYPE_BAGGAGE,
            'child': common.RideDetails.TICKET_TYPE_CHILD,
            'full': common.RideDetails.TICKET_TYPE_FULL,
        }

    @cfields.converter
    class GenderType(common.RideDetails.GenderType):
        conv = {
            'male': common.RideDetails.GENDER_TYPE_MALE,
            'female': common.RideDetails.GENDER_TYPE_FEMALE,
        }

    fields = {
        'docTypes': fields.List(
            fields.Nested(
                {
                    'code': fields.String(attribute='code'),
                    'type': DocumentType(attribute='type'),
                }
            ),
            attribute='docTypes',
        ),
        'ticketTypes': fields.List(
            fields.Nested(
                {
                    'code': fields.String(attribute='code'),
                    'type': TicketType(attribute='type'),
                    'price': cfields.Price(attribute='price'),
                    'onlinePrice': cfields.Price(attribute='onlinePrice'),
                }
            ),
            attribute='ticketTypes',
        ),
        'genderTypes': fields.List(fields.Nested({
            'code': fields.String(attribute='code'),
            'type': GenderType(attribute='type'),
        })),
        'citizenships': fields.Raw(attribute='__not_existent__',
                                   default=[{'code': c, 'name': c} for c in common.citizenships]),
        'seats': fields.Raw(attribute='__not_existent__'),
    }

    @classmethod
    def format(cls, value):
        value['ticketTypes'] = value['ticketTypes'][0]
        return super(RideDetails, cls).format(value)
