# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from yabus.atlasbus.entities.ride_details import RideDetails

from yabus.atlasbus.identifiers import TicketID
from yabus.common import fields as cfields, ticket
from yabus import common

from flask_restful import fields


class Ticket(common.Ticket):

    @cfields.id_wrapper(TicketID)
    class TicketID(cfields.Dict):
        pass

    @cfields.converter
    class Status(common.Ticket.Status):
        conv = {
            'active': ticket.STATUS_BOOKED,
            'confirmed': ticket.STATUS_BOOKED,
            'cancelled': ticket.STATUS_CANCELLED,
            'expired': ticket.STATUS_CANCELLED,
            'unknown': ticket.STATUS_UNKNOWN,
            'waiting_confirmation': ticket.STATUS_CREATED,
            'error': ticket.STATUS_ERROR,
            'booked': ticket.STATUS_BOOKED,
            'landing': ticket.STATUS_BOOKED,
        }

    fields = {
        '@id': TicketID(ticket_sid='id', order_sid='order_sid'),
        'supplierId': fields.String(attribute='id'),
        'status': Status(attribute='status'),
        'url': fields.String(attribute='__not_existent__'),
        'price': cfields.Price(attribute='onlinePrice'),
        'priceVat': fields.String,
        'feeVat': fields.String,
        'passenger': {
            'phone': fields.String(attribute='passenger.phone'),
            'firstName': fields.String(attribute='passenger.firstName'),
            'middleName': fields.String(attribute='passenger.middleName'),
            'lastName': fields.String(attribute='passenger.lastName'),
            'birthDate': cfields.ISODate(attribute='passenger.birthDate', dt_format=b'iso8601'),
            'genderType': RideDetails.GenderType(attribute='passenger.genderType'),
            'docType': RideDetails.DocumentType(attribute='passenger.docType'),
            'docNumber': fields.String(attribute='passenger.docNumber'),
            'ticketType': RideDetails.TicketType(attribute='passenger.ticketType'),
            'citizenship': fields.String(attribute='__not_existent__'),
            'seat': fields.String(attribute='passenger.seat', default='0'),
        },
    }
