# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import typing

import gevent
from travel.library.python.rasp_vault.api import get_secret

import config
from yabus import common
from yabus.atlasbus import defaults
from yabus.common.exceptions import PartnerError


class Session(common.Session):

    def __init__(self, url=defaults.URL, login=None, password=None, **kwargs):
        # type: (typing.Text, typing.Text, typing.Text, **dict) -> None
        secrets = get_secret(config.CONNECTOR_SECRET_NAME)
        self.login = login or secrets['atlasbus-login']
        self.password = password or secrets['atlasbus-token']
        super(Session, self).__init__(url, **kwargs)

    def request(self, method, path, polling=True, **kwargs):
        # type: (bytes, typing.Text, bool, **dict) -> dict
        headers = kwargs.get('headers', {})
        headers['Content-Type'] = 'application/json'
        kwargs['headers'] = headers

        while True:
            res = super(Session, self).request(method, path, auth=(self.login, self.password), **kwargs)
            if res.status_code == 200:
                break
            if res.status_code == 202:
                if not polling:
                    break
                gevent.sleep(defaults.POLLING_INTERVAL)
            else:
                raise PartnerError('unexpected status while polling: {}'.format(res.status_code))

        if res.encoding is None:
            res.encoding = "utf-8"  # avoiding expensive chardet
        return res.json() if res.text else {}
