# -*- coding: utf-8 -*-
from yabus.common.entities.entity import Entity
from yabus.common.fields import ValidationWarning
from yabus.common import fields as cfields
from yabus import common

from flask_restful import fields


class Book(common.Book):
    table = {}

    @classmethod
    def format(cls, value):
        return [x.format(value) for x in cls.table.values()]

    @classmethod
    def _validate_item(cls, item, path):
        if not isinstance(item, dict):
            return ValidationWarning(path, cls.invalid_type(dict, type(item)))
        name = item.get('Name')
        if name is None:
            return [ValidationWarning(path + ['name'], "must not be None")]
        elif name not in cls.table:
            msg = "must be one of {}, got {}".format(name, cls.table.keys())
            return [ValidationWarning(path + ['name'], msg)]
        return cls.table[name].validate(item, path)

    @classmethod
    def validate(cls, instance, path):
        if not isinstance(instance, list):
            return [ValidationWarning(path, cls.invalid_type(list, type(instance)))]
        return [e for item in instance for e in cls._validate_item(item, path)]

    @classmethod
    def add(cls, name):
        def decorator(cls1):
            cls.table[name] = cls1
            field = fields.Raw(attribute='__not_exsistent__', default=name)
            cls1.fields['Name'] = field
            return cls1
        return decorator


@Book.add('Удостоверение')
class DocumentData(Entity):
    fields = {
        'Value': fields.FormattedString('{docSeries} {docNumber}'),
        'ValueKind': fields.String(attribute='docTypeCode'),
    }

    @classmethod
    def format(cls, value):
        if value['docTypeCode'] == u'Паспорт гражданина РФ':
            value['docSeries'] = '{} {}'.format(value['docSeries'][:2], value['docSeries'][2:])
        return super(DocumentData, cls).format(value)


@Book.add('ФИО')
class NameData(Entity):
    fields = {
        'Value': fields.FormattedString('{lastName} {firstName} {middleName}'),
    }


@Book.add('Дата рождения')
class BirthDateData(Entity):
    fields = {
        'Value': fields.String(attribute='birthDate'),
    }


@Book.add('Мобильный телефон')
class MobilePhoneData(Entity):
    fields = {
        'Value': fields.String(attribute='phone'),
    }


@Book.add('Телефон')
class PhoneData(Entity):
    fields = {
        'Value': fields.String(attribute='phone'),
        'ValueKind': cfields.Constant('Мобильный телефон'),
    }


@Book.add('Гражданство')
class CitizenshipData(Entity):
    fields = {
        'Value': fields.String(attribute='citizenshipCode'),
    }


@Book.add('Пол')
class GenderData(Entity):
    fields = {
        'Value': fields.String(attribute='genderCode'),
    }


@Book.add('Место рождения')
class Birthplace(Entity):
    fields = {
        'Value': cfields.Constant('default-city'),
    }
