from yabus.common import fields as cfields
from yabus import common

from flask_restful import fields


class Endpoint(common.Endpoint):
    class EndpointType(common.Endpoint.Type):
        def format(self, value):
            return 'station'

    class Location(fields.Float):
        def __init__(self, pos, **kwargs):
            super(fields.Float, self).__init__(**kwargs)
            self._pos = pos

        def format(self, value):
            try:
                return float(value.split(',')[self._pos].strip())
            except ValueError:
                return self.default
            except LookupError:
                return self.default

    fields = {
        'supplier_id': fields.Raw(attribute='Id'),
        'title': fields.String(attribute='Name'),
        'description': cfields.ConcatString('Address', 'Region', 'District'),
        'type': cfields.Constant('station'),
        'country': fields.String(attribute='Country'),
        'region': fields.String(attribute='Region'),
        'district': fields.String(attribute='District'),
        'latitude': Location(pos=0, attribute='GPSCoordinates'),
        'longitude': Location(pos=1, attribute='GPSCoordinates'),
        'timezone_info': fields.String(attribute='UTC'),
        'extra_info': fields.String(attribute='Address'),
    }
