# -*- coding: utf-8 -*-
from yabus.avibus.entities.ticket import Ticket
from yabus import common

from datetime import datetime, timedelta
from flask_restful import fields
from tzlocal import get_localzone as localtz


class Order(common.Order):
    class ExpirationDateTime(fields.DateTime):
        def format(self, value):
            value = datetime.now(localtz()) + timedelta(seconds=value)
            return super(Order.ExpirationDateTime, self).format(value)

    fields = {
        'supplierId': fields.String(attribute='Number'),
        'price': fields.Float(attribute='Amount'),
        'expirationDateTime': ExpirationDateTime(attribute='SecondsToUnlockSeats', dt_format='iso8601'),
        'tickets': fields.List(Ticket, attribute='Tickets'),
    }
