# -*- coding: utf-8 -*-
from yabus.common import fields as cfields
from yabus import common

from datetime import datetime
from flask_restful import fields


class Ride(common.Ride):
    class Status(common.Ride.Status):
        statuses = {
            'Cancelled': 2,
            'Departed': 3,
            'Arrived': 5,
            'Waiting': 1,
            'Unknown': 0,
        }

        def __init__(self, sale_status, status):
            common.Ride.Status.__init__(self)
            self.sale_status = sale_status
            self.status = status

        def output(self, key, obj):
            sale_status = obj.get(self.sale_status)
            if sale_status:
                status = obj[self.status]
                value = self.statuses.get(status)
            else:
                value = None
            return self.format(value)

    class ArrivalTime(fields.DateTime):
        def format(self, value):
            # 0001-01-01 == no value
            if value == datetime.fromordinal(1):
                return None
            return super(Ride.ArrivalTime, self).format(value)

    fields = {
        'status': Status(sale_status='OnSale', status='Status'),
        'number': fields.Raw(attribute='RouteNum'),
        'name': fields.Raw(attribute='RouteName'),
        'carrier': fields.Raw(attribute='Carrier'),
        'bus': fields.Raw(attribute='Bus.Name'),
        'departure': fields.DateTime(attribute='DepartureTime', dt_format='iso8601'),
        'arrival': ArrivalTime(attribute='ArrivalTime', dt_format='iso8601'),
        'price': fields.Float(attribute='PassengerFareCost'),
        'freeSeats': fields.Integer(attribute='FreeSeatsAmount'),
        'ticketLimit': fields.Integer(attribute='FreeSeatsAmount'),
    }
