# -*- coding: utf-8 -*-
from yabus.avibus.entities.ride_details import RideDetails
from yabus.avibus.citizenships import citizenships
from yabus import common

from datetime import datetime
from flask_restful import fields


class Ticket(common.Ticket):
    @common.fields.converter
    class Country(fields.Raw):
        conv = citizenships

    class Date(fields.DateTime):
        def format(self, value):
            value = datetime.strptime(value[:10], '%d.%m.%Y')
            return super(Ticket.Date, self).format(value)

    fields = {
        'supplierId': fields.String(attribute='Number'),
        'data': {
            'id': fields.String(attribute='Number'),
            'code': fields.String(attribute='Number'),
            'number': fields.String(attribute='Number'),
            'series': fields.String(attribute='TripId'),
        },
        'price': fields.Float(attribute='Calculation.TotalAmount'),
        'passenger': fields.Nested({
            'birthDate': Date(dt_format='iso8601'),
            'genderType': RideDetails.GenderType,
            'citizenship': Country,
            'docType': RideDetails.DocumentType,
            'ticketType': RideDetails.TicketType,
            'seat': fields.String(default='0'),
        }),
    }

    @classmethod
    def format(cls, value):
        personal_value = {x['Name']: x for x in value['PersonalData']}
        last_name, first_name, middle_name = personal_value['ФИО']['Value'].split()
        doc_value = personal_value['Удостоверение']
        birth_date = personal_value.get('Дата рождения', {}).get('Value')
        value['passenger'] = {
            'firstName': first_name,
            'middleName': middle_name,
            'lastName': last_name,
            'birthDate': birth_date if birth_date != '01.01.0001 0:00:00' else None,
            'genderType': personal_value.get('Пол', {}).get('Value'),
            'citizenship': personal_value.get('Гражданство', {}).get('Value'),
            'docType': doc_value['ValueKind'],
            'docNumber': doc_value['Value'],
            'ticketType': value['FareName'],
            'seat': value['SeatNum'],
        }
        return super(Ticket, cls).format(value)
