# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from yabus.common import exceptions
from yabus.util import dump_response


code_to_error = {
    'WRONG_SERIE_DOCUMENT': exceptions.InvalidCredentials,
    'UNKNOWN_BUSSTOP': exceptions.InvalidRide,
}


def parse_error(func):
    def wrapper(*args, **kwargs):
        try:
            return func(*args, **kwargs)
        except exceptions.PartnerError as e:
            error_type = code_to_error.get(e.fault.get('code'), exceptions.Error)
            msg = e.fault.get('description') or e.args[0]
            raise error_type(msg, context=dump_response(e.response))
    return wrapper
