# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from yabus.common.exceptions import PartnerError
from yabus.common.soapclient import HttpAuthenticated
from yabus.util import decode_utf8, pairwise
from yabus import common

import re


class SoapClient(common.SoapClient):
    def __init__(self, url, username, password):
        transport = HttpAuthenticated(username, password)
        super(SoapClient, self).__init__(url, transport=transport)

    def call(self, method, args):
        args = decode_utf8(args)
        try:
            response = super(SoapClient, self).call(method, args)
        except PartnerError as e:
            fault = self._parse_fault(e)
            raise PartnerError(fault.get('description'), e.response, fault)
        return decode_utf8(response)

    @staticmethod
    def _parse_tag(s, tag):
        regex = r'<{tag}>([^<]*)</{tag}>'.format(tag=tag)
        retval = re.findall(regex, s)
        if not (retval and all(x == y for x, y in pairwise(retval))):
            raise ValueError
        return retval[0]

    @staticmethod
    def _parse_fault(exc):
        data = exc.message
        try:
            return {
                'description': SoapClient._parse_tag(data, 'errordescription'),
                'code': SoapClient._parse_tag(data, 'errorcode'),
                'details': SoapClient._parse_tag(data, 'errordetails'),
            }
        except Exception:
            return {
                'description': data,
            }
