# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from flask_restful import fields

from yabus.busfor.defaults import MIDDLENAME_CAP
from yabus.common.fields import Required
from yabus import common


class Book(common.Book):

    class MiddleName(fields.String):
        def __init__(self, *args, **kwargs):
            super(self.__class__, self).__init__(*args, default=MIDDLENAME_CAP, **kwargs)

        def format(self, value):
            return super(Book.MiddleName, self).format(value if value else MIDDLENAME_CAP)

    fields = {
        'birthday': Required(fields.String(attribute='birthDate'), types=basestring),
        'citizenship': Required(fields.String(attribute='citizenshipCode'), types=basestring),
        'document': Required(fields.FormattedString('{docSeries}{docNumber}'), types=basestring),
        'documenttype': Required(fields.String(attribute='docTypeCode'), types=basestring),
        'firstname': Required(fields.String(attribute='firstName'), types=basestring),
        'gender': Required(fields.String(attribute='genderCode'), types=basestring),
        'lastname': Required(fields.String(attribute='lastName'), types=basestring),
        'middlenames': Required(MiddleName(attribute='middleName'), types=basestring),
        'number': Required(fields.Integer(attribute='passenger_number')),
        'tariff_code': Required(fields.String(attribute='ticketTypeCode'), types=basestring),
    }
