# coding: utf-8
from flask_restful import fields

from yabus import common
from yabus.busfor.entities.ride import Ride


class RefundInfo(common.RefundInfo):
    fields = {
        'price': fields.Float(attribute='__not_existent__'),
        'available': fields.Boolean(attribute='is_online_refund', default=False),
    }


class Refund(common.Refund):
    fields = {
        'price': Ride.Price(attribute='returned_amount'),
    }
