# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import typing

from yabus import common
from yabus.busfor import defaults


class Session(common.Session):

    def __init__(self, url=defaults.URL, language=defaults.LANGUAGE, token=None, **kwargs):
        # type: (typing.Text, typing.Text, typing.Optional[typing.Text], **dict) -> None
        super(Session, self).__init__(url, **kwargs)
        self.headers[b"Accept-Language"] = language
        if token is not None:
            self.headers[b"Authorization"] = b"Bearer {}".format(token)

    def request(self, method, path, raw=False, **kwargs):
        # type: (bytes, typing.Text, bool, **dict) -> dict
        kwargs.setdefault("params", {}).setdefault(
            "lang_array", defaults.LANGUAGE
        )  # TODO remove when busfor fix Accept-Language support
        res = super(Session, self).request(method, path, **kwargs)
        if res.encoding is None:
            res.encoding = "utf-8"  # avoiding expensive chardet
        if raw:
            return res.content
        return res.json() if res.text else {}
