# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

import yabus.providers


class CarrierMatcher(object):
    def __init__(self, carrier_matching_provider, supplier_provider, carrier_provider, logger):
        self._carrier_matching_provider = carrier_matching_provider
        self._supplier_provider = supplier_provider
        self._carrier_provider = carrier_provider

        self._logger = logger
        super(CarrierMatcher, self).__init__()

    def get_carrier(self, supplier_code, carrier_code):
        supplier = self._supplier_provider.get_by_code(supplier_code)
        if supplier is None:
            self._logger.error('Unknown supplier %s', supplier_code)
            return None

        supplier_id = supplier.id
        carrier_id = self._carrier_matching_provider.get_by_key(
            supplier_id=supplier_id,
            carrier_code=carrier_code,
        )

        if carrier_id is None:
            self._logger.debug('Can not find carrier by matching rule (%d/%s)', supplier_id, carrier_code)
            return None

        carrier = self._carrier_provider.get_by_id(carrier_id)
        if carrier is None:
            self._logger.debug('Can not find carrier by carrier_id %d', carrier_id)
            return None

        return carrier


carrier_matcher = CarrierMatcher(
    carrier_matching_provider=yabus.providers.carrier_matching_provider,
    supplier_provider=yabus.providers.supplier_provider,
    carrier_provider=yabus.providers.carrier_provider,
    logger=logging.getLogger(__name__),
)
