# -*- coding: utf-8 -*-
from yabus.common.entities.entity import Entity
from yabus.common.fields import (
    ValidationError,
    ValidationErrorBundle,
    ValidationWarning,
)

from flask_restful import fields
from datetime import datetime


class Book(Entity):
    """
    fields = {
        'firstName': fields.Raw,
        'middleName': fields.Raw,
        'lastName': fields.Raw,
        'birthDate': fields.Raw,
        'genderCode': fields.Raw,
        'citizenshipCode': fields.Raw,
        'docTypeCode': fields.Raw,
        'docSeries': fields.Raw,
        'docNumber': fields.Raw,
        'ticketTypeCode': fields.Raw,
        'seatCode': fields.Raw,
        'phone': fields.Raw,
        'email': fields.Raw,
    }
    """

    class Date(fields.Raw):
        def format(self, value):
            return datetime.strptime(value[:10], '%Y-%m-%d')

    @classmethod
    def init(cls, *args, **kwargs):
        try:
            return super(Book, cls).init(*args, **kwargs)
        except ValidationErrorBundle as e:
            raise ValidationErrorBundle(
                instance=None,
                exceptions=map(cls._mk_error, e.exceptions)
            )

    @staticmethod
    def _mk_error(e):
        if isinstance(e, ValidationWarning):
            return ValidationError(msg=str(e))
        return e
