from flask_restful import fields

from yabus.common import fields as cfields
from yabus.common.entities.entity import Entity
from yabus.common.fields import Optional, Required, ValidationError


class Endpoint(Entity):
    class Type(fields.Raw, cfields.Validatable):
        enum = {'city', 'station'}

        def output(self, key, obj):
            return self.format(fields.get_value(
                key if self.attribute is None else self.attribute, obj
            ))

        def validate(self, value, path):
            if value not in self.enum:
                return [ValidationError(path, "is not valid: must be one of {}".format(self.enum))]
            return []

    fields = {
        'supplier_id': Required(fields.Raw),
        'type': Required(Type),
        'title': Required(fields.Raw),
        'description': Optional(fields.String),
        'latitude': Optional(fields.Float),
        'longitude': Optional(fields.Float),
        'country': Optional(fields.Raw),
        'country_code': Optional(fields.String),
        'city_id': Optional(fields.Raw),
        'city_title': Optional(fields.String),
        'region': Optional(fields.String),
        'region_code': Optional(fields.String),
        'district': Optional(fields.String),
        'timezone_info': Optional(fields.String),
        'extra_info': Optional(fields.String),
    }
