# -*- coding: utf-8 -*-
from yabus.common.entities.entity import Entity
from yabus.common.entities.ticket import Ticket
from yabus.common.fields import Optional, Required, ValidationError
from yabus.common import fields as cfields

from flask_restful import fields
from tzlocal import get_localzone as localtz

from datetime import datetime, timedelta


class Order(Entity):
    class ExpirationDateTime(fields.DateTime):
        def __init__(self, delta=timedelta(minutes=15), **kwargs):
            fields.DateTime.__init__(self, **kwargs)
            self.delta = delta

        def output(self, key, obj):
            retval = super(Order.ExpirationDateTime, self).output(key, obj)
            if retval == self.default:
                retval = self.format(datetime.now(localtz()) + self.delta)
            return retval

    fields = {
        'partner': Optional(fields.String),
        'partnerName': Required(fields.String),
        '@id': Required(fields.String),
        'supplierId': Required(fields.String),
        'status': Required(Ticket.Status, types=dict),
        'price': Required(cfields.Price, types=float),
        'expirationDateTime': Optional(ExpirationDateTime(dt_format='iso8601'), types=basestring),
        'tickets': fields.List(Ticket),
    }

    @classmethod
    def enrich(cls, data, tickets_fwd=None, **kwargs):
        tickets_fwd = tickets_fwd or {}
        tickets_key = cls.fields['tickets'].attribute or 'tickets'
        ticket_field = cls.fields['tickets'].container
        if isinstance(ticket_field, Entity):
            for ticket in fields.get_value(tickets_key, data) or []:
                ticket_field.enrich(ticket, **tickets_fwd)
                ticket_field.enrich(ticket, __partner__=cls.fields['partner'].default)
        return super(Order, cls).enrich(data, **kwargs)

    @classmethod
    def validate(cls, instance, path):
        exceptions = super(Order, cls).validate(instance, path)
        status = instance['status']['name']
        if status == 'booked' and not instance['expirationDateTime']:
            exceptions.append(ValidationError(path + ['expirationDateTime'], "must not be None"))
        return exceptions
