# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from functools import partial

from yabus.common.session import Session


METH_ALL = {
    'CONNECT',
    'DELETE',
    'GET',
    'HEAD',
    'OPTIONS',
    'PATCH',
    'POST',
    'PUT',
    'TRACE',
}


class HttpClient(object):
    """Implementation of common http functions for http-based clients."""
    session_cls = Session

    def __init__(self, *args, **kwargs):
        self.session = lambda: self.session_cls(*args, **kwargs)

    def __getattr__(self, name):
        upper_name = name.upper()
        if upper_name not in METH_ALL:
            raise AttributeError("{0.__name__!r} object has no attribute {1!r}".format(type(self), name))

        def wrapper(*args, **kwargs):
            with self.session() as session:
                default = partial(session.request, upper_name)
                return getattr(session, name, default)(*args, **kwargs)

        return wrapper
