# -*- coding: utf-8 -*-
from yabus.common.exceptions import InvalidIdentifier

import base64
from datetime import datetime
import json
from os import getenv


HMAC_SECRET = getenv('YANDEX_BUS_API_HMAC_SECRET', '')


class Identifier(dict):
    def dumps(self):
        copy = self.copy()
        # hotfix
        if 'date' in copy:
            copy['date'] = copy['date'].isoformat()
        return base64.b64encode(json.dumps(copy, sort_keys=True))

    @staticmethod
    def loads(string):
        try:
            data = json.loads(base64.b64decode(string))
            if not Identifier._is_valid(data, HMAC_SECRET):
                raise InvalidIdentifier
            # hotfix
            if 'date' in data:
                data['date'] = datetime.strptime(data['date'], '%Y-%m-%dT%H:%M:%S')
            return Identifier(data)
        except:
            raise InvalidIdentifier

    @staticmethod
    def _is_valid(data, key):
        return isinstance(data, dict)
