# -*- coding: utf-8 -*-
from yabus.ecolines.session import Session
from yabus import common

from itertools import permutations


class BaseClient(common.HttpClient):
    session_cls = Session

    def __init__(self, *args, **kwargs):
        super(BaseClient, self).__init__(*args, **kwargs)
        stations = self.get('stops', params={'all': 1})
        self._stations = {x['id']: x['title'] for x in stations}
