# -*- coding: utf-8 -*-
from yabus.common.fields import Optional, Required
from yabus import common

from flask_restful import fields


class Book(common.Book):
    _hack_keys = [
        'genderCode',
        'birthDate',
        'citizenshipCode',
        'docTypeCode',
        'docNumber',
        'docSeries',
        'seatCode',
    ]

    class Seat(fields.Raw):
        def format(self, value):
            return [int(value)]

    class TrickyNote(fields.Raw):
        def __init__(self, keys):
            self.keys = keys

        def output(self, key, obj):
            return common.cipher.encrypt({k: obj[k] for k in self.keys})

    fields = {
        'firstName': Required(fields.String, types=basestring),
        'lastName': Required(fields.String, types=basestring),
        'tariff': Required(fields.Integer(attribute='ticketTypeCode'), types=(int, long)),
        'seats': Required(Seat(attribute='seatCode'), types=list),
        'phone': Optional(fields.String),
        'discount': Optional(fields.String(attribute='__not_existent__')),
        'email': Optional(fields.String),
        'gender': Required(fields.String(attribute='genderCode'), types=basestring),
        'dateOfBirth': Required(fields.String(attribute='birthDate'), types=basestring),
        'citizenship': Required(fields.String(attribute='citizenshipCode'), types=basestring),
        'documentType': Required(fields.Integer(attribute='docTypeCode'), types=(int, long)),
        'documentNumber': Required(fields.String(attribute='docNumber'), types=basestring),
        'documentSeries': Required(fields.String(attribute='docSeries'), types=basestring),
        'note': Required(TrickyNote(_hack_keys), types=basestring),
    }
