from yabus.common import fields as cfields
from yabus import common

from flask_restful import fields
from yabus.common.fields.fields import pillow


class Endpoint(common.Endpoint):

    fields = {
        'supplier_id': fields.String(attribute='id'),
        'title': fields.String(attribute='title'),
        'description': fields.FormattedString('{state}, {description}'),
        'latitude': pillow(fields.Float)(attribute='location.latitude'),
        'longitude': pillow(fields.Float)(attribute='location.longitude'),
        'type': cfields.Constant('station'),
        'country_code': fields.String(attribute='state'),
    }
