# -*- coding: utf-8 -*-
from datetime import timedelta

from flask_restful import fields

from yabus import common
from yabus.common import fields as cfields
from yabus.ecolines.entities.ride import Ride
from yabus.ecolines.entities.ticket import Ticket
from yabus.ecolines.identifiers import OrderID


class Order(common.Order):
    @cfields.id_wrapper(OrderID)
    class OrderID(cfields.Dict):
        pass

    class TotalPrice(Ride.Price):
        def output(self, key, obj):
            return self.format(sum(t['price'] for t in obj['tickets'] if t['price']))

    fields = {
        'partner': cfields.Constant('ecolines'),
        'partnerName': cfields.Constant('Ecolines'),
        '@id': OrderID(order_sid='id'),
        'supplierId': fields.String(attribute='id'),
        'expirationDateTime': common.Order.ExpirationDateTime(
            attribute='__not_existent__',
            dt_format='iso8601',
            delta=timedelta(minutes=20)),
        'price': TotalPrice,
        'status': Ticket.Status,
        'tickets': fields.List(Ticket),
    }

    @classmethod
    def enrich(cls, obj, tickets):
        for ticket in tickets:
            ticket['order_id'] = obj['id']
        return super(Order, cls).enrich(obj, tickets=tickets)
