# -*- coding: utf-8 -*-
from flask_restful import fields

from yabus import common
from yabus.common import fields as cfields
from yabus.ecolines.entities.ride import Ride
from yabus.ecolines.entities.ride_details import RideDetails
from yabus.ecolines.identifiers import TicketID


class Ticket(common.Ticket):
    @cfields.id_wrapper(TicketID)
    class TicketID(cfields.Dict):
        pass

    @cfields.converter
    class Status(common.Ticket.Status):
        conv = {
            'waiting': 1,
            'confirmed': 7,
            'deleted': 2,
            'canceled': 2,
        }

    fields = {
        '@id': TicketID(ticket_sid='id', order_sid='order_id'),
        'supplierId': fields.String(attribute='id'),
        'status': Status,
        'data': {
            'id': fields.String(attribute='id'),
            'code': fields.String(attribute='id'),
            'number': fields.String(attribute='id'),
            'series': fields.String(attribute='order_id'),
        },
        'price': Ride.Price,
        'passenger': {
            'birthDate': cfields.ISODate(dt_format='iso8601', attribute='birthDate'),
            'genderType': RideDetails.GenderType(attribute='genderCode'),
            'citizenship': fields.String(attribute='citizenshipCode'),
            'docType': RideDetails.DocumentType(attribute='docTypeCode'),
            'docNumber': cfields.SeparatedDocumentNumber(series_attribute='docSeries', number_attribute='docNumber'),
            'ticketType': RideDetails.TicketType(attribute='tariff'),
            'seat': fields.String(attribute='seatCode', default='0'),
        },
    }

    @classmethod
    def format(cls, value):
        value.update(common.cipher.decrypt(value['note']))
        return super(Ticket, cls).format(value)
