# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from yabus.common import exceptions
from yabus.util import dump_response

__all__ = [
    'parse_error',
]


def parse_error(func):
    def wrapper(*args, **kwargs):
        try:
            return func(*args, **kwargs)
        except exceptions.PartnerError as e:
            raise exceptions.Error(e.message, context=dump_response(e.response))
    return wrapper
