# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from travel.library.python.rasp_vault.api import get_secret

import config
from yabus import common
from yabus.common.exceptions import PartnerError
from yabus.ecolines import defaults


class Session(common.Session):
    def __init__(self, url=None, login=None, password=None, **kwargs):
        secrets = get_secret(config.CONNECTOR_SECRET_NAME)
        self.login = login or secrets['ecolines-login']
        self.password = password or secrets['ecolines-token']
        super(Session, self).__init__(url or defaults.URL, **kwargs)

    def request(self, method, path, **kwargs):
        headers = kwargs.get('headers', {})
        headers['Content-Type'] = 'application/json'
        kwargs['headers'] = headers
        try:
            resp = super(Session, self).request(method, path, auth=(self.login, self.password), **kwargs)
        except PartnerError as e:
            self._handle_error(e)
        else:
            return self._response(resp)

    @staticmethod
    def _response(response):
        if not response.content:
            return None
        return response.json()

    @staticmethod
    def _handle_error(e):
        try:
            error = e.response.json()
            raise PartnerError(error['message'], e.response, error)
        except Exception:
            raise e
