# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from gevent import spawn

from yabus.etraffic.entities import Country
from yabus.etraffic.segments_provider import segments_provider
from yabus.etraffic.soapclient import SoapClient
from yabus.util.formatting import python


class BaseClient(SoapClient):
    def __init__(self, spawn_segments_provider=True, *args, **kwargs):
        super(BaseClient, self).__init__(*args, **kwargs)
        countries = python(self.call('getCountries', []))
        self.countries = [Country.init(x) for x in countries]

        if spawn_segments_provider:
            spawn(segments_provider.run, client=self)
