# -*- coding: utf-8 -*-
from yabus.common.fields import Required, Optional
from yabus import common
from yabus.etraffic.entities.ride_details import RideDetails

from datetime import datetime
from flask_restful import fields


class Book(common.Book):
    BC_DOC_NUM_LEN = 6  # length of document number of a birth certificate
    BC_SERIES_CYR_LEN = 2  # length of cyrillic letters part of a series in a birth certificate
    SEP = '-'

    @classmethod
    def format(cls, value):
        obj = super(Book, cls).format(value)
        if value.get('docTypeId', '') == RideDetails.DOC_TYPE_BIRTH_CERT:
            if not obj['docSeries']:
                doc_num = obj['docNum'][-Book.BC_DOC_NUM_LEN:]
                series = obj['docNum'][:-Book.BC_DOC_NUM_LEN]
                if Book.SEP not in series:
                    series = Book.SEP.join([series[:-Book.BC_SERIES_CYR_LEN], series[-Book.BC_SERIES_CYR_LEN:]])
                obj['docNum'] = doc_num
                obj['docSeries'] = series
        return obj

    fields = {
        'firstName': Required(fields.String, types=basestring),
        'middleName': Required(fields.String, types=basestring),
        'lastName': Required(fields.String, types=basestring),
        'birthday': Required(common.Book.Date(attribute='birthDate'), types=datetime),
        'gender': Required(fields.String(attribute='genderCode'), types=basestring),
        'citizenship': Required(fields.String(attribute='citizenshipCode'), types=basestring),
        'docTypeCode': Required(fields.String, types=basestring),
        'docSeries': Required(fields.String, types=basestring),
        'docNum': Required(fields.String(attribute='docNumber'), types=basestring),
        'ticketTypeCode': Optional(fields.String, types=basestring),
        'seatCode': Required(fields.String, types=basestring),
        'phone': Optional(fields.String, types=basestring),
    }
