# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from yabus import common
from yabus.common import fields as cfields

from flask_restful import fields


class Endpoint(common.Endpoint):
    class EndpointType(common.Endpoint.Type):
        def format(self, value):
            return 'city' if bool(value) else 'station'

    fields = {
        'supplier_id': fields.String(attribute='id'),
        'title': fields.String(attribute='name'),
        'description': cfields.ConcatString('name', 'region', 'address', 'details'),
        'type': EndpointType(attribute='place'),
        'city_id': fields.Raw(attribute='city_id'),
        'latitude': cfields.pillow(fields.Float)(attribute='latitude'),
        'longitude': cfields.pillow(fields.Float)(attribute='longitude'),
        'district': fields.String(attribute='details'),
        'region': fields.String(attribute='region'),
        'region_code': fields.String(attribute='region_info.code'),
        'country': fields.String(attribute='region_info.country.fullName'),
        'country_code': fields.String(attribute='region_info.country.code'),
        'timezone_info': fields.String(attribute='timezone'),
        'extra_info': fields.String(attribute='okato'),
    }
