# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

from flask_restful import fields

from yabus import common
from yabus.common import fields as cfields

from yabus.etraffic.defaults import SUPPLIER_CODE
from yabus.etraffic.entities.ticket import Ticket
from yabus.etraffic.identifiers import OrderID


class Order(common.Order):
    @cfields.id_wrapper(OrderID)
    class OrderID(cfields.Dict):
        pass

    fields = {
        'partner': cfields.Constant(SUPPLIER_CODE),
        'partnerName': cfields.Constant('Е-траффик'),
        '@id': OrderID(order_sid='id'),
        'supplierId': fields.String(attribute='id'),
        'status': Ticket.Status,
        'price': fields.Float(attribute='total'),
        'tickets': fields.List(Ticket),
    }
