# coding: utf-8

from travel.library.python.rasp_vault.api import get_secret

from yabus.common.soapclient import HttpAuthenticated
from yabus.etraffic import defaults
from yabus import common

import config


class SoapClient(common.SoapClient):
    def __init__(self, host=None, version=None, wsdl=None, username=None, password=None):
        self.host = host or defaults.HOST
        self.version = version or defaults.VERSION
        wsdl = wsdl or defaults.WSDL
        secrets = get_secret(config.CONNECTOR_SECRET_NAME)
        super(SoapClient, self).__init__(
            '/'.join([self.host, self.version, wsdl]),
            transport=HttpAuthenticated(
                username or secrets['etraffic-login'],
                password or secrets['etraffic-token'],
            ),
        )
