# -*- coding: utf-8 -*-
from travel.library.python.rasp_vault.api import get_secret

from yabus.noy.converter import point_converter
from yabus.noy import entities
from yabus.noy import defaults
from yabus import avibus

import config

# no test instance available, so in test environment connector is switched off - no login/token in test secret
# except cases with explicit params in __init__
class Client(avibus.Client):
    converter = point_converter
    partner = 'noy'

    def __init__(self, url=None, username=None, password=None):
        secrets = get_secret(config.CONNECTOR_SECRET_NAME)
        super(Client, self).__init__(
            converter=point_converter,
            entities=entities,
            url=url or defaults.URL,
            username=username or secrets['noy-login'],
            password=password or secrets['noy-token'],
        )
