# -*- coding: utf-8 -*-
from yabus.avibus.entities import order
from yabus.noy.entities.ticket import Ticket
from yabus.noy.identifiers import OrderID
from yabus.common import fields as cfields
from yabus import common

from flask_restful import fields


class Order(order.Order):
    class OrderID(common.fields.Dict):
        def output(self, key, obj):
            values = super(Order.OrderID, self).output(key, obj)
            return OrderID(**values).dumps()

    fields = {
        'partner': cfields.Constant('noy'),
        'partnerName': cfields.Constant('НОЙ'),
        '@id': OrderID(order_sid='Number'),
        'tickets': fields.List(Ticket, attribute='Tickets'),
    }
