# -*- coding: utf-8 -*-
from yabus.avibus.entities import ride
from yabus.noy.converter import point_converter
from yabus.noy.identifiers import RideID
from yabus.common import fields as cfields
from yabus import common

from flask_restful import fields


class Ride(ride.Ride):
    @cfields.id_wrapper(RideID)
    class RideID(cfields.Dict):
        pass

    fields = {
        'connector': cfields.Constant('noy'),
        'partner': cfields.Constant('noy'),
        'partnerName': cfields.Constant('НОЙ'),
        '@id': RideID(
            ride_sid='Id',
            from_sid='Departure.Id',
            to_sid='Destination.Id'),
        'from': common.Ride.Endpoint(
            id=common.Ride.Point(converter=point_converter, attribute='Departure.Id'),
            desc=fields.Raw(attribute='Departure.Name'),
            supplier_id=fields.String(attribute='Departure.Id')),
        'to': common.Ride.Endpoint(
            id=common.Ride.Point(converter=point_converter, attribute='Destination.Id'),
            desc=fields.Raw(attribute='Destination.Name'),
            supplier_id=fields.String(attribute='Destination.Id')),
    }

    @classmethod
    def format(cls, value):
        instance = super(Ride, cls).format(value)
        if isinstance(instance, list):
            for ride, ride_value in zip(instance, value):
                cls._add_own_carrier(ride, ride_value)
        elif isinstance(instance, dict):
            cls._add_own_carrier(instance, value)
        return instance

    @classmethod
    def _add_own_carrier(cls, instance, value):
        if instance.get('carrierModel'):
            return

        carrier = value.get('CarrierData')
        if not carrier:
            return

        inn = carrier.get('CarrierTaxId')
        register_number = carrier.get('CarrierStateRegNum')
        if not inn and not register_number:
            return

        instance['carrierModel'] = {
            "registerNumber": register_number,
            "name": carrier.get('CarrierName'),
            "legalName": carrier.get('CarrierName'),
            "inn": inn,
            "timetable": carrier.get('CarrierWorkingHours') or common.Ride.default_carrier_timetable,
        }
