# -*- coding: utf-8 -*-
from flask_restful import fields

from yabus import common
from yabus.avibus.entities import ride_details
from yabus.noy.converter import point_converter


class RideDetails(ride_details.RideDetails):
    fields = {
        'from': common.RideDetails.Endpoint(
            id=common.Ride.Point(converter=point_converter, attribute='Departure.Id'),
            desc=fields.Raw(attribute='Departure.Name')),
        'to': common.RideDetails.Endpoint(
            id=common.Ride.Point(converter=point_converter, attribute='Destination.Id'),
            desc=fields.Raw(attribute='Destination.Name'))
    }
