# -*- coding: utf-8 -*-
from yabus.ok.entities import Country
from yabus.ok.session import Session

from yabus import common


def init_base_client(client):
    countries = client.get('citizenship/list', {})
    client.countries = [Country.init(x) for x in countries.get('citizenship_list', [])]


class BaseClient(common.HttpClient):
    session_cls = Session

    def __init__(self, url=None, agent_id=None, secret=None):
        super(BaseClient, self).__init__(url, agent_id, secret)
        init_base_client(self)
