# -*- coding: utf-8 -*-
from yabus.common.fields import Required
from yabus import common

from flask_restful import fields


class Book(common.Book):
    class Position(fields.Raw):
        def format(self, value):
            return {'0': None}.get(value, value) or self.default

    fields = {
        'name': Required(fields.FormattedString('{lastName} {firstName} {middleName}'), types=basestring),
        'birthday': Required(fields.String(attribute='birthDate'), types=basestring),
        'gender': Required(fields.Integer(attribute='genderCode'), types=int),
        'citizenship_id': Required(fields.Integer(attribute='citizenshipCode'), types=int),
        'card_identity_id': Required(fields.Integer(attribute='docTypeCode'), types=int),
        'series_number': Required(fields.FormattedString('{docSeries}{docNumber}'), types=basestring),
        'position': Required(Position(attribute='seatCode', default='auto'), types=basestring),
        'phone': Required(fields.String(default=''), types=basestring),
        'email': Required(fields.String(default='support@bus.yandex.ru'), types=basestring),
        'tariff_id': Required(fields.Integer(attribute='ticketTypeCode'), types=int),
    }
