from flask_restful import fields

from yabus import common
from yabus.common import fields as cfields


class Endpoint(common.Endpoint):

    fields = {
        'supplier_id': fields.Raw(attribute='id'),
        'title': fields.String(attribute='title'),
        'description': cfields.ConcatString('station_title', 'city_title', 'district_title', 'region_title',
                                            'country_title'),
        'latitude': cfields.pillow(fields.Float)(attribute='lat'),
        'longitude': cfields.pillow(fields.Float)(attribute='lng'),
        'type': fields.String(attribute='type'),
        'district': fields.String(attribute='district_title'),
        'region': fields.String(attribute='region_title'),
        'region_code': fields.String(attribute='region_title'),
        'country': fields.String(attribute='country_title'),
        'country_code': fields.String(attribute='country_code'),
        'city_id': fields.String(attribute='city_id'),
        'city_title': fields.String(attribute='city_title')
    }
