# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from datetime import datetime, timedelta

from dateutil import tz
from flask_restful import fields

from yabus import common
from yabus.common import fields as cfields
from yabus.ok.entities.ticket import Ticket
from yabus.ok.identifiers import OrderID


class Order(common.Order):
    @cfields.id_wrapper(OrderID)
    class OrderID(cfields.Dict):
        pass

    @cfields.converter
    class OrderStatus(common.Ticket.Status):
        conv = {
            3: 1,
            2: 2,
            1: 7,
        }

    class ExpirationDateTime(fields.DateTime):
        def format(self, value):
            value = datetime.now(tz.UTC) + timedelta(seconds=value)
            return super(Order.ExpirationDateTime, self).format(value)

    fields = {
        'partner': cfields.Constant('ok'),
        'partnerName': cfields.Constant('ОднаКасса'),
        '@id': OrderID(order_sid='operation_id'),
        'supplierId': fields.String(attribute='operation_id'),
        'status': OrderStatus,
        'tickets': fields.List(Ticket, attribute='ticket_list'),
        'expirationDateTime': ExpirationDateTime(attribute='time_left_to_cancel', dt_format='iso8601'),
    }

    @classmethod
    def format(cls, value):
        instance = super(Order, cls).format(value)
        instance['price'] = sum([x['price'] for x in instance['tickets']], 0.0)
        return instance
