# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from logging import getLogger

from travel.library.python.rasp_vault.api import get_secret

import config
from yabus import common
from yabus.common.exceptions import PartnerError
from yabus.ok import defaults
from yabus.ok.params import Params

logger = getLogger(__name__)


class Session(common.Session):
    def __init__(self, url=None, agent_id=None, secret=None, **kwargs):
        secrets = get_secret(config.CONNECTOR_SECRET_NAME)
        self.agent_id = agent_id or secrets['ok-login']
        self.secret = secret or secrets['ok-token']
        super(Session, self).__init__(url or defaults.URL, **kwargs)

    def request(self, *args, **kwargs):
        raw = kwargs.pop('raw', False)
        return Session._response(super(Session, self).request(*args, **kwargs), raw)

    def get(self, path, params, **kwargs):
        if not isinstance(params, Params):
            params = Params(params, self.agent_id, self.secret)
        return super(Session, self).get(path, params=params or {}, **kwargs)

    def post(self, path, data, **kwargs):
        params = Params(data, self.agent_id, self.secret)
        for k in data.keys():
            del params[k]
        return super(Session, self).post(path, data=data, params=params, **kwargs)

    @staticmethod
    def _response(response, raw=False):
        if raw:
            return response
        json = response.json()
        error = json.get('error')
        if error and 400 <= error['code'] <= 500:
            raise PartnerError("{error_code}: {error_message}".format(**error), response, error)
        return json.get('data', {})
