# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
import six

from travel.library.python.dicts.buses.carrier_matching_repository import CarrierMatchingRepository

import config
from util.lazy_setuper import LazySetuper
from yabus.util.carrier_name_normalization import normalize

try:
    import pathlib
except ImportError:
    import pathlib2 as pathlib


class CarrierMatchingProvider(LazySetuper):
    def __init__(self, logger):
        super(CarrierMatchingProvider, self).__init__()
        self._logger = logger
        self._index = {}

    def _setup(self, carrier_matching_repository=None):
        if carrier_matching_repository is None:
            carrier_matching_repository = CarrierMatchingRepository()
            carrier_matching_repository.load_from_file(
                six.text_type(pathlib.Path(config.RASP_DATA_PATH) / "carrier_matching.bin")
            )

        for carrier_matching in carrier_matching_repository.itervalues():
            key = self._gen_index_key(carrier_matching.supplier_id, carrier_matching.code)
            if key in self._index:
                self._logger.warning("Carrier matching duplicate key: {}. Ignored".format(key))
                continue
            self._index[key] = carrier_matching.carrier_id

    @staticmethod
    def _gen_index_key(supplier_id, carrier_code):
        return supplier_id, normalize(six.ensure_text(carrier_code))

    @LazySetuper.setup_required
    def get_by_key(self, supplier_id, carrier_code):
        if carrier_code is None:
            return None
        key = self._gen_index_key(supplier_id, carrier_code)
        return self._index.get(key)


carrier_matching_provider = CarrierMatchingProvider(
    logger=logging.getLogger(__name__),
)
